unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, Math, ComCtrls, ClipBrd;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Timer2: TTimer;
    Timer3: TTimer;
    Cursor: TLabel;

    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;

    Image1: TImage;
    Image2: TImage;
    Memo1: TMemo;

    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;

    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    Copyright: TLabel;

    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

    procedure Timer1Timer(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);

    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);

    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
  private
    { Private declarations }
    procedure CMDialogKey(var Msg: TCMDialogKey); message CM_DIALOGKEY;
    procedure WMSysCommand(var Msg: TWMSysCommand); message WM_SYSCOMMAND;
  public
    { Public declarations }
    procedure WMKeyDown(var Msg: TWMKeyDown); message WM_KEYDOWN;
  end;

var
  Form1: TForm1;

implementation

uses Unit2;

{$R *.DFM}

procedure TForm1.CMDialogKey(var Msg: TCMDialogKey);   // allows tab key to be used
begin
  if Msg.CharCode<>VK_TAB then inherited
end;

procedure TForm1.WMSysCommand(var Msg: TWMSysCommand); // disable hotkey passthrough
begin                                                  // (alt-keys producing error beep)
  if Msg.CmdType<>SC_KEYMENU then inherited
end;


var  hRead_local:THandle;
    hWrite_local:THandle;
     hRead_remote:THandle;
    hWrite_remote:THandle;

var WriteBuffer:string;
        LogFile:text;

var CSR:TLabel;                          // used as a shortcut to cursor object
    SCR:TCanvas;                         // used as a shortcut to text screen
    GFX:TCanvas;                         // used as a shortcut to graphics screen

const FGdefault=7;
      BGdefault=0;

const FGcolour:integer=FGdefault;        // initial foreground colour
      BGcolour:integer=BGdefault;        // initial background colour
      TxtStyle:TFontStyles=[];           // initial style (underline, bold, etc)
       DimText:boolean=false;            // low intensity flag
       InvText:boolean=false;            // inverse video flag

          Xpos:integer=1;                // initial cursor column
          Ypos:integer=1;                // initial cursor row

         lastK:char=#000;                // last ascii key pressed
         lastC:char=#000;                // last ascii character printed

        mouseX:integer=0;                // last mouse X position
        mouseY:integer=0;                // last mouse Y position

           CLC:integer=0;                // counter of lines added to command log

           TC1:DWORD=0;                  // timestamp of last serial port data
           TC2:DWORD=0;                  // timestamp of last keyboard event
      CBstring:string='';
      CBlength:integer=0;
       CBindex:integer=0;

const BreakCounter:integer=-1;           // used to time sending a break
         CONNECTED:boolean=false;        // true if serial port connected
         LOGTOFILE:boolean=false;        // true if logging text to a file
              KILL:boolean=false;        // kill signal to application loop
              DEAD:boolean=false;        // response from application loop

const ROWS=24;
      COLS=80;

var TextStore:array[1..COLS, 1..ROWS] of char;


const CPC:array [0..15] of TColor=(clBlack, clNavy, clGreen, clTeal,
                                 clMaroon, clPurple, clOlive, clSilver,
                                 clGray, clBlue, clLime, clAqua,
                                 clRed, clFuchsia, clYellow, clWhite);
{   (dim)           (bright)
0 = Black 	8 = Gray
1 = Blue 	9 = Light Blue
2 = Green 	A = Light Green
3 = Aqua 	B = Light Aqua     (Cyan)
4 = Red 	C = Light Red
5 = Purple 	D = Light Purple   (Magenta)
6 = Yellow 	E = Light Yellow
7 = White 	F = Bright White
}
const CVT:array [0..15] of TColor=(clBlack, clMaroon, clGreen, clOlive,
                                   clNavy, clPurple, clTeal, clSilver,
                                   clGray, clRed, clLime, clYellow,
                                   TColor($FF8080), clFuchsia, clAqua, clWhite);
                                   //bright blue//

{       (0-7 = dim, 8-15 = bright)
30	Black
31	Red
32	Green
33	Yellow
34	Blue
35	Magenta   (Purple)
36	Cyan      (Aqua)
37	White
}

// returns how much time has elapsed since GetTickCount was assigned to counter
function timesince(counter:DWORD):int64;
var I:int64;
begin
  I:=GetTickCount-counter;
  if I<0 then I:=I+$100000000;
  timesince:=I
end;


////////////////////////////////////////////////////////////////////////////////
// the following routines are the text plane primatives. this plane sits
// behind the graphics plane. the following commands are provided:
// putch (x, y, character)              - puts a single character at (x,y)
// gotoxy (x, y)                        - moves cursor to (x,y)
// clear (x1, y1, x2, y2)               - clears a rectangular area
// scroll (x1, y1, x2, y2, direction)   - direction can be -1 (down) or +1 (up)
// emit (ch)                            - print (ch) at cursor, update cursor
////////////////////////////////////////////////////////////////////////////////

procedure putch(X, Y:integer; ch:char);
var mask:byte;
begin
  if DimText then mask:=$0
             else mask:=$8;
  if InvText then begin
                    SCR.Font.Color:=CVT[BGcolour or mask];
                    SCR.Brush.Color:=CVT[FGColour]
                  end
             else begin
//                  if mask=$0 then ShowMessage(IntToStr(FGcolour));
                    SCR.Font.Color:=CVT[FGcolour or mask];
                    SCR.Brush.Color:=CVT[BGColour]
                  end;
  SCR.Font.Style:=TxtStyle;
  SCR.TextOut(CSR.Width*(X-1),CSR.Height*(Y-1),ch);

  TextStore[X, Y]:=ch;
  lastC:=ch
end;


procedure gotoxy(X, Y:integer);        // -1 indicate no change
begin
  if X<>-1 then
  begin
    Xpos:=X;               // Xpos = 1 .. ROWS
    if Xpos<1 then Xpos:=1;
    if Xpos>COLS then Xpos:=COLS
  end;

  if Y<>-1 then
  begin
    Ypos:=Y;               // Ypos = 1 .. COLS
    if Ypos<1 then Ypos:=1;
    if Ypos>ROWS then Ypos:=ROWS
  end;

  CSR.Tag:=1                           // flag cursor position as moved
end;


procedure clear(X1, Y1, X2, Y2:integer);
var X, Y:integer;
begin
  SCR.Brush.Color:=CVT[BGColour];
  SCR.FillRect(Rect(CSR.Width*(X1-1),CSR.Height*(Y1-1),
                    CSR.Width*(X2),  CSR.Height*(Y2)  ));
  for Y:=Y1 to Y2 do
  for X:=X1 to Y1 do textStore[X,Y]:=' '
end;


procedure scroll(X1, Y1, X2, Y2, direction:integer);   // +1 = scroll up, -1 = scroll down
var R1, R2:TRect;
      X, Y:integer;
begin
  R1:=Rect(CSR.Width*(X1-1),CSR.Height*(Y1-1),         // upper rectangle
           CSR.Width*(X2)  ,CSR.Height*(Y2-1));
  R2:=Rect(CSR.Width*(X1-1),CSR.Height*(Y1  ),         // lower rectangle
           CSR.Width*(X2)  ,CSR.Height*(Y2)  );

  SCR.Brush.Color:=CVT[BGColour];
  case direction of +1:begin                           // scroll screen upwards by 1 line
                         SCR.CopyRect(R1, SCR, R2);    // destination=R1, canvas, source=R2
                         R2.Top:=R1.Bottom;
               //        inc(R2.Bottom);
               //        inc(R2.Right);
                         SCR.FillRect(R2);
                         for Y:=Y1 to Y2-1 do
                         for X:=X1 to X2 do TextStore[X,Y]:=TextStore[X,Y+1];
                         for X:=X1 to X2 do textStore[X,Y2]:=' '
                       end;
                    -1:begin;                          // scroll screen downwards by 1 line
                         SCR.CopyRect(R2, SCR, R1);    // destination=R2, canvas, source=R1
                         R1.Bottom:=R2.Top;    // -1;
               //        inc(R1.Right);
                         SCR.FillRect(R1);
                         for Y:=Y1+1 to Y2 do
                         for X:=X1 to X2 do TextStore[X,Y-1]:=TextStore[X,Y];
                         for X:=X1 to X2 do textStore[X,Y1]:=' '
                       end
                 else ShowMessage('invalid scroll value (+1,-1 required)')
  end  { of case }
end;


procedure emit(ch:char);
begin
  lastC:=ch;
  if ch<#32 then case ch of #05:WriteBuffer:=WriteBuffer+#06;        // ENQ -> ACK
                            #07:windows.beep(440,250);               // bell
                            #08:if Xpos<>1 then dec(Xpos);           // backspace
                            #09:repeat                               // tab
                                  putch(Xpos, Ypos, ' ');
                                  inc(Xpos)
                                until (Xpos-1) mod 8=0;
                            #10:begin                                // linefeed
                                  inc(Ypos);
                                  if Ypos>ROWS then
                                  begin
                                    scroll(1, 1, COLS, ROWS, +1);
                                    Ypos:=ROWS
                                  end
                                end;
                            #13:Xpos:=1;                             // carriage return
                            #17:;                                    // DC 1
                            #18:;                                    // DC 2
                            #19:;                                    // DC 3
                            #20:;                                    // DC 4
                            #27:;                                    // escape
                 end  { of case }
            else begin
                   if Xpos>COLS then
                   begin
                     Xpos:=1;
                     Ypos:=Ypos+1
                   end;

                   if Ypos>ROWS then
                   begin
                     scroll(1, 1, COLS, ROWS, +1);
                     Ypos:=ROWS
                   end;
                   putch(Xpos, Ypos, ch);
                   inc(Xpos)
                 end;

  if ch in [#8,#9,#10,#13,#32..#255] then CSR.Tag:=1;      // flag cursor position as moved

  if LOGTOFILE and (ch in [#8,#9,#10,#13,#32..#255]) then
  try
    Write(Logfile, ch)                                     // write to log file
  except
    try closefile(LogFile) except end;
    LOGTOFILE:=false
  end
end;


////////////////////////////////////////////////////////////////////////////////
// the following routines are the graphic plane primatives. this plane sits
// in front of the text plane. the following commands are provided:
// Gw                              - returns width of graphic area
// Gh                              - returns height of graphic area
// GFXclear ((X1, Y1, X2, Y2)      - erase a rectular area
// GFXlineAB (X1, Y1, X2, Y2)      - draw a line from (x1,y1) to (x2,y2)
// GFXarc (X1, Y1, X2, Y2, A1, A2) - draw arc within a rectangle, between A1 and A2 degrees
// GFXplot (X, Y)                  - plot a single pixel
// GFXink (R, G, B, width)         - set ink colour and pen width
// GFXfill (X, Y)                  - fill an area we have just enclosed
// GFXmoveto (X, Y)                - set starting location
// DFXdrawto (X, Y)                - draw from previous location to (x,y)
// GFXscroll(X1, Y1, X2, Y2,
//           deltaX, deltaY)       - scroll a graphics area
////////////////////////////////////////////////////////////////////////////////

function Gw:integer;
begin
  Gw:=Form1.Image2.Picture.Graphic.Width
end;


function Gh:integer;
begin
  Gh:=Form1.Image2.Picture.Graphic.Height
end;


procedure GFXclear(X1, Y1, X2, Y2:integer);
begin
  GFX.Brush.Color:=clBlack;
  GFX.FillRect(Rect(X1,Y1,X2,Y2))
end;


procedure GFXlineAB(X1, Y1, X2, Y2:integer);
begin
  GFX.MoveTo(X1, Y1);
  GFX.LineTo(X2, Y2);                  // draw line, excluding the last point
  GFX.LineTo(X2, Y2)                   // fill in last point ????????????????
end;


procedure GFXarc(X1, Y1, X2, Y2:integer; A1, A2:single);
var X0, Y0, X3, Y3, X4, Y4:integer;
begin
  A1:=(A1*pi/180.0)-(pi/2.0);            // convert A1 to radians, shift origin ccw 1/4 turn
  A2:=(A2*pi/180.0)-(pi/2.0);            // convert A2 to radians, shift origin ccw 1/4 turn

  X0:=(X1 + X2) div 2;                   // locate centre of elipse: X0
  Y0:=(Y1 + Y2) div 2;                   // locate centre of elipse: Y0

  X3:=X0 + trunc(1000.0*Cos(A2));
  Y3:=Y0 + trunc(1000.0*Sin(A2));
  X4:=X0 + trunc(1000.0*Cos(A1));
  Y4:=Y0 + trunc(1000.0*Sin(A1));

  GFX.Arc(X1, Y1, X2, Y2, X3, Y3, X4, Y4)
end;


procedure GFXplot(X, Y:integer);
begin
  GFX.Pixels[X, Y]:=GFX.Pen.Color
end;


procedure GFXink(R, G, B:byte; width:integer);
begin
  GFX.Pen.Color:=(B*$10000)+(G*$100)+R;
  GFX.Pen.Width:=width
end;


procedure GFXfill(X, Y:integer);
begin
  GFX.Brush.Color:=GFX.Pen.Color;                  // select pen colour as fill
  GFX.FloodFill(X, Y, GFX.Pen.Color, fsBorder);    // fill everything we previously set to black
  GFX.Brush.Color:=clBlack                         // go back to a black brush
(*
  GFX.Brush.Color:=clBlack;                        // select black fill colour
  GFX.FloodFill(X, Y, GFX.Pen.Color, fsBorder);    // fill area bounded by pen colour
  GFX.Brush.Color:=GFX.Pen.Color;                  // select pen colour as fill
  GFX.FloodFill(X, Y, clBlack, fsSurface);         // fill everything we previously set to black
  GFX.Brush.Color:=clBlack                         // go back to a black brush
*)
end;


procedure GFXmoveto(X, Y:integer);
begin
  GFX.MoveTo(X, Y)                                 // set starting point of a multi-line
end;


procedure GFXdrawto(X, Y:integer);
begin
  GFX.LineTo(X, Y)                                 // draw line to (x,y)
end;                                               // excluding the last point


procedure GFXscroll_OLD(X1, Y1, X2, Y2, deltaX, deltaY:integer);
var R1, R2, Fh, Fv:TRect;
begin
  if (deltaX=0) and (deltaY=0) then exit;      // nothing to do!

// R1 is the source rectangle, R2 is the destingation rectangle
  if deltaX<0 then begin                       // moving *** left ***
                     R1.Left:=X1-deltaX;       // - source left side
                     R1.Right:=X2;             // - source right side
                     R2.Left:=X1;              // - destination left side
                     R2.Right:=X2+deltaX;      // - destination right side

                     Fv.Left:=R2.Right+1;
                     Fv.Right:=X2+1            // +1 as fillrect skips right side
                   end
              else begin                       // moving *** right ***
                     R1.Left:=X1;              // - source left side
                     R1.Right:=X2-deltaX;      // - source right side
                     R2.Left:=X1+deltaX;       // - destination left side
                     R2.Right:=X2;             // - destination right side

                     Fv.Left:=X1;
                     Fv.Right:=R2.Left         // fillrect skips right side
                   end;
  Fv.Top:=Y1;
  Fv.Bottom:=Y2+1;                             // +1 as fillrect skips bottom edge

  if deltaY<0 then begin                       // moving *** up ***
                     R1.Top:=Y1-deltaY;        // - source top side
                     R1.Bottom:=Y2;            // - source bottom side
                     R2.Top:=Y1;               // - destination top side
                     R2.Bottom:=Y2+deltaY;     // - destination bottom side

                     Fh.Top:=R2.Bottom+1;
                     Fh.Bottom:=Y2+1           // +1 as fillrect skips bottom edge
                   end
              else begin                       // moving *** down  ***
                     R1.Top:=Y1;               // - source top side
                     R1.Bottom:=Y2-deltaY;     // - source bottom side
                     R2.Top:=Y1+deltaY;        // - destination top side
                     R2.Bottom:=Y2;            // - destination bottom side

                     Fh.Top:=Y1;
                     Fh.Bottom:=R2.Top         // fillrect skips bottom edge
                   end;
  Fh.Left:=X1;
  Fh.Right:=Y2+1;                              // +1 as fillrect skips right side

  GFX.CopyRect(R2, GFX, R1);    // destination=R2, canvas, source=R1

  GFX.Brush.Color:=clBlack;
  if deltaX<>0 then GFX.FillRect(Fv);
  if deltaY<>0 then GFX.FillRect(Fh)
end;

////////////////////////////////////////////////////////////////////////////////
// assumes CopyRect and FillRect both skip right column and bottom row        //
////////////////////////////////////////////////////////////////////////////////
procedure GFXscroll(X1, Y1, X2, Y2, deltaX, deltaY:integer);
var R1, R2, Fh, Fv:TRect;
begin
  if (deltaX=0) and (deltaY=0) then exit;      // nothing to do!
  inc(X2);
  inc(Y2);

// R1 is the source rectangle, R2 is the destingation rectangle
  if deltaX<0 then begin                       // moving *** left ***
                     R1.Left:=X1-deltaX;       // - source left side
                     R1.Right:=X2;             // - source right side
                     R2.Left:=X1;              // - destination left side
                     R2.Right:=X2+deltaX;      // - destination right side

                     Fv.Left:=R2.Right;
                     Fv.Right:=X2
                   end
              else begin                       // moving *** right ***
                     R1.Left:=X1;              // - source left side
                     R1.Right:=X2-deltaX;      // - source right side
                     R2.Left:=X1+deltaX;       // - destination left side
                     R2.Right:=X2;             // - destination right side

                     Fv.Left:=X1;
                     Fv.Right:=R2.Left         // fillrect skips right side
                   end;
  Fv.Top:=Y1;
  Fv.Bottom:=Y2;                               // +1 as fillrect skips bottom edge

  if deltaY<0 then begin                       // moving *** up ***
                     R1.Top:=Y1-deltaY;        // - source top side
                     R1.Bottom:=Y2;            // - source bottom side
                     R2.Top:=Y1;               // - destination top side
                     R2.Bottom:=Y2+deltaY;     // - destination bottom side

                     Fh.Top:=R2.Bottom;
                     Fh.Bottom:=Y2             // +1 as fillrect skips bottom edge
                   end
              else begin                       // moving *** down  ***
                     R1.Top:=Y1;               // - source top side
                     R1.Bottom:=Y2-deltaY;     // - source bottom side
                     R2.Top:=Y1+deltaY;        // - destination top side
                     R2.Bottom:=Y2;            // - destination bottom side

                     Fh.Top:=Y1;
                     Fh.Bottom:=R2.Top         // fillrect skips bottom edge
                   end;
  Fh.Left:=X1;
  Fh.Right:=Y2;                                // +1 as fillrect skips right side

  GFX.CopyRect(R2, GFX, R1);    // destination=R2, canvas, source=R1

  GFX.Brush.Color:=clBlack;
  if deltaX<>0 then GFX.FillRect(Fv);
  if deltaY<>0 then GFX.FillRect(Fh)
end;

////////////////////////////////////////////////////////////////////////////////
// the follow are the communications (serial) port routines:
// SetupCommPort (CommPortName, Config:string)
// ReadComm (var ch:char):boolean
// WriteComm (ch:char);
////////////////////////////////////////////////////////////////////////////////

var CommFile:THandle;


procedure SetupCommPort(CommPortName, Config:string);
var DeviceName:array [0..80] of char;
           DCB:TDCB;
       CommTOs:TCommTimeouts;
          proc:string;
begin
  WriteBuffer:='';
  try
    CommPortName:=copy(CommPortName,1,80);             // 80 characters max
    StrPCopy(DeviceName, '\\.\'+CommPortName);
    proc:='CreateFile';
    CommFile:=CreateFile(DeviceName,
                         GENERIC_READ or GENERIC_WRITE,
                         0, Nil,
                         OPEN_EXISTING,
                         FILE_ATTRIBUTE_NORMAL, 0);
    if (CommFile=INVALID_HANDLE_VALUE) then
    begin
      ShowMessage('Serial I/O error: '+proc+' failed');
      exit
    end;
    proc:='SetupComm';
    if not SetupComm(CommFile, 1024, 1024) then
    begin
      try CloseHandle(CommFile) except end;
      ShowMessage('Serial I/O error: '+proc+' failed');
      exit
    end;
    proc:='GetCommState';
    if not GetCommState(CommFile, DCB) then
    begin
      try CloseHandle(CommFile) except end;
      ShowMessage('Serial I/O error: '+proc+' failed');
      exit
    end;
//    Config:='baud='+IntToStr(38400)+' parity=n data=8 stop=1 xon=off'#0;   // port parameters
    Config:=Config+#0;                                                       // xon={on|off}
    proc:='BuildCommDCB';
    if not BuildCommDCB(@Config[1], DCB) then
    begin
      try CloseHandle(CommFile) except end;
      ShowMessage('Serial I/O error: '+proc+' failed');
      exit
    end;
    proc:='SetCommState';
    if not SetCommState(CommFile, DCB) then
    begin
      try CloseHandle(CommFile) except end;
      ShowMessage('Serial I/O error: '+proc+' failed');
      exit
    end;
    with CommTOs do
    begin
      ReadIntervalTimeout := 10;               // 0
      ReadTotalTimeoutMultiplier := 0;         // 0
      ReadTotalTimeoutConstant := 10;          // 300
      WriteTotalTimeoutMultiplier := 0;        // 0
      WriteTotalTimeoutConstant := 10          // 300
    end;
    proc:='SetCommTimeouts';
    if not SetCommTimeouts(CommFile, CommTOs) then
    begin
      try CloseHandle(CommFile) except end;
      ShowMessage('Serial I/O error: '+proc+' failed');
      exit
    end
  except
    try CloseHandle(CommFile); except end;
    ShowMessage('Serial I/O error: '+proc+' exception');
    exit
  end;
  CONNECTED:=true
end;


function ReadComm(var ch:char):boolean;
const lock:boolean=false;
var got, error:DWORD;
begin
  ReadComm:=false;
  if lock or not CONNECTED then exit;
  lock:=true;
//inc(LC1);
  try
    if not ReadFile(CommFile, ch, 1, got, nil) then
    begin
      error:=GetLastError;
      try CloseHandle(CommFile); except end;
      ShowMessage('Serial I/O error: ReadFile failed'+#13+
                  '('+IntToStr(error)+')  '+SysErrorMessage(GetLastError));
      CONNECTED:=false;
      lock:=false;
      exit
    end
  except
    try CloseHandle(CommFile); except end;
    ShowMessage('Serial I/O error: ReadFile exception');
    CONNECTED:=false;
    lock:=false;
    exit
  end;
  ReadComm:=(got<>0);
  lock:=false;
end;


procedure WriteComm_OLD(ch:char);       ////////////////////////////////////////
const lock:boolean=false;               // superseded by string write version //
var put, error:DWORD;                   ////////////////////////////////////////
begin
  if lock or not CONNECTED then exit;
  lock:=true;
//inc(LC2);
  try
    if not WriteFile(CommFile, ch, 1, put, nil) then
    begin
      error:=GetLastError;
      try CloseHandle(CommFile); except end;
      ShowMessage('Serial I/O error: WriteFile failed'+#13+
                  '('+IntToStr(error)+')  '+SysErrorMessage(GetLastError));
      CONNECTED:=false;
      lock:=false;
      exit
    end
  except
    try CloseHandle(CommFile); except end;
    ShowMessage('Serial I/O error: WriteFile exception');
    CONNECTED:=false;
    lock:=false;
    exit
  end;
  lock:=false
end;                                    ////////////////////////////////////////


procedure WriteComm(S:string);
const lock:boolean=false;
var put, error:DWORD;
begin
  if lock or not CONNECTED then exit;
  lock:=true;
//inc(LC2);
  try
    if not WriteFile(CommFile, S[1], length(S), put, nil) then
    begin
      error:=GetLastError;
      try CloseHandle(CommFile); except end;
      ShowMessage('Serial I/O error: WriteFile failed'+#13+
                  '('+IntToStr(error)+')  '+SysErrorMessage(GetLastError));
      CONNECTED:=false;
      lock:=false;
      exit
    end
  except
    try CloseHandle(CommFile); except end;
    ShowMessage('Serial I/O error: WriteFile exception');
    CONNECTED:=false;
    lock:=false;
    exit
  end;
  lock:=false
end;


////////////////////////////////////////////////////////////////////////////////
// the following is a VT100 command processing engine. it takes characters one
// at a time via the parameter 'ch'. normally these are simply passed out
// unaltered as a one character long return string to then be passed onto
// emit(ch).
//
// however, when a VT100 command sequence is detected characters are accumulated
// in the internal string 'VTline'. once matched to a valid VT100 command, the
// command is enacted. while if the string accumulated is detected as invalid,
// the whole string is returned.
////////////////////////////////////////////////////////////////////////////////

// const IgnoreCount:integer=0;

function VT100engine(ch:char):string;
const VTflag:boolean=false;         // internally held flag
      VTline:string='';             // internally held string
      Xsave:integer=-1;
      Ysave:integer=-1;
         TM:integer=-maxint;
         BM:integer=+maxint;
var n, v, h, I, J:integer;
                S:string;

  function PC(S:string):integer;       // returns count of semicolon delimited parameters
  var I, dc, sc:integer;               // or -1 if any invalid characters are found
  begin
    if length(S)=0 then PC:=0 else     // empty string -> no parameters
    begin
      dc:=0;                           // number of digits
      sc:=0;                           // number of semicolon delimiters
      for I:=1 to length(S) do
      begin
        if S[I] in ['0'..'9'] then inc(dc);
        if S[I]=';' then inc(sc);
      end;
      if (dc+sc)<>length(S) then PC:=-1         // invalid characters found
                            else PC:=sc+1       // number of parameters in S
    end
  end;      // ( 1;2 = 2 parameters, 1;;2 = 3 parameters, ;;; = 4 parameters

  function Pn(S:string; n:integer):integer;     // returns parameter n as an integer
  var I:integer;
  begin
    while (n>1) and (length(S)<>0) do
    begin
      if pos(';', S)=1 then dec(n);
      delete(S, 1, 1)
    end;
    if (length(S)=0) or (S[1]=';') then Pn:=0 else
    begin
      I:=pos(';', S);
      if I<>0 then S:=copy(S, 1, I-1);
      if length(S)=0 then Pn:=0
                     else Pn:=StrToInt(S)
    end
  end;

  function OK(S:string; var n:integer):boolean;            // returns true if a valid number
  begin                                                    // (with number placed in n)
    OK:=true;
    try
      if length(S)=0 then n:=0
                     else n:=StrToInt(S)
    except
      OK:=false
    end
  end;

  procedure fail;             // failed to decode string
  begin
    if Form2.Visible then with Form2.RichEdit1 do
    begin
      inc(CLC);
      Lines.BeginUpdate;
      if CLC>999 then Lines.Delete(0);
      Lines.Add(Format('%.6d  ',[CLC mod 1000000])+
                'FAIL: <ESC>'+copy(VTline,2,length(VTline)-1));
      SendMessage(Handle, WM_VSCROLL, SB_BOTTOM, 0);
      Lines.EndUpdate
    end;

    VT100engine:=VTline;      // return complete string
    VTline:='';
    VTflag:=false              // drop out of VT100 mode
  end;

  procedure pass;             // sucessfully processed string
  begin
    if Form2.Visible then with Form2.RichEdit1 do
    begin
      inc(CLC);
      Lines.BeginUpdate;
      if CLC>999 then Lines.Delete(0);
      Lines.Add(Format('%.6d  ',[CLC mod 1000000])+
                'PASS: <ESC>'+copy(VTline,2,length(VTline)-1));
      SendMessage(Handle, WM_VSCROLL, SB_BOTTOM, 0);
      Lines.EndUpdate
    end;

    VTline:='';
    VTflag:=false             // drop out of VT100 mode
  end;

begin
  if ch=#27 then VTflag:=true;
  if not VTflag then VT100engine:=ch else
  begin
    VT100engine:='';
    VTline:=VTline+ch;
    if length(VTline)=1 then exit;

    if pos(#27+'[', VTline)=1 then           // process a complete <esc>[ string
    begin
      if length(VTline)=2 then exit;         // still building command string
      if ch in ['0'..'9',';'] then exit;     // still building command string

      S:=copy(VTline, 3, length(VTline)-3);  // extract parameter segment

      case ch of 'A':begin                   // move cursor up n lines
                       if not OK(S, n) then fail else
                       begin
//                       ShowMessage('UP '+IntToStr(n));
                         if n=0 then n:=1;
                         gotoxy(-1, Ypos-n);
                         pass
                       end
                     end;
                 'B':begin                   // move cursor down n lines
                       if not OK(S, n) then fail else
                       begin
//                       ShowMessage('DOWN '+IntToStr(n));
                         if n=0 then n:=1;
                         gotoxy(-1, Ypos+n);
                         pass
                       end
                     end;
                 'C':begin                   // move cursor right n columns
                       if not OK(S, n) then fail else
                       begin
//                       ShowMessage('RIGHT '+IntToStr(n));
                         if n=0 then n:=1;
                         gotoxy(Xpos+n, -1);
                         pass
                       end
                     end;
                 'D':begin                   // move cursor left n columns
                       if not OK(S, n) then fail else
                       begin
//                       ShowMessage('LEFT '+IntToStr(n));
                         if n=0 then n:=1;
                         gotoxy(Xpos-n, -1);
                         pass
                       end
                     end;
             'H','f':begin                   // position cursor
                       n:=PC(S);
//                     showmessage('position cursor |'+S+'|'+VTline+'| '+IntToStr(n));
                       case n of 0:begin
                                     gotoxy(1, 1);
//                                   ShowMessage('top left');
                                     pass
                                   end;
                                 2:begin
                                     v:=Pn(S,1);
                                     h:=Pn(S,2);
                                     if v=0 then v:=1;
                                     if h=0 then h:=1;
                                     gotoxy(h, v);
//                                   showmessage('row = '+IntToStr(v)+'  col = '+IntToStr(h));
                                     pass
                                   end
                              else fail
                       end  { of case }
                     end;
                 'J':if not OK(S, n) then fail else            // clear screen above/below cursor
                     case n of 0:begin                         // clear cursor to end of screen
                                   clear(Xpos, Ypos, COLS, Ypos);
                                   if Ypos<>ROWS then clear(1, Ypos, COLS, ROWS);
                                   pass
                                 end;
                               1:begin                         // clear start of screen to cursor
                                   if Ypos<>1 then clear(1, 1, COLS, Ypos-1);
                                   clear(1, Ypos, Xpos, Ypos);
                                   pass
                                 end;
                               2:begin                         // clear whole screen
                                   clear(1, 1, COLS, ROWS);
                                   gotoxy(1, 1);
                                   pass
                                 end
                            else fail
                     end;  { of case }
                 'K':if not OK(S, n) then fail else            // clear line to left/right of cursor
                     case n of 0:begin                         // clear cursor to EOL
                                   clear(Xpos, Ypos, COLS, Ypos);
                                   pass
                                 end;
                               1:begin                         // clear SOL to cursor
                                   clear(1, Ypos, Xpos, Ypos);
                                   pass
                                 end;
                               2:begin                         // clear whole line
                                   clear(1, Ypos, COLS, Ypos);
                                   pass
                                 end
                                else fail
                     end;  { of case }
//                   if IgnoreCount<>0 then begin dec(IgnoreCount); pass end else 'm':
                 'm':begin
                       if S='' then S:='0';
                       n:=PC(S);
//                     ShowMessage(IntToStr(n)+'  |'+S+'|');
                       if n=-1 then fail else
                       begin
                         for I:=1 to n do
                         begin
                           J:= Pn(S,I);
                           case J of 0:begin
//                                       ShowMessage('reset colours and attributes');
                                         DimText:=false;
                                         InvText:=false;
                                         FGcolour:=FGdefault;
                                         BGcolour:=BGdefault;
                                         TxtStyle:=[]
////////////////////////////////////////////////////////////////////////////////////////////
//                                       ; Form2.RichEdit1.Lines.Add('reset attributes '+
//                                                                   IntToStr(FGcolour)+' '+
//                                                                   IntToStr(BGcolour))
//                                       ; IgnoreCount:=2;
////////////////////////////////////////////////////////////////////////////////////////////
                                       end;
                                     1:TxtStyle:= TxtStyle+[fsBold];       // bold
                                     2:DimText:=true;                      // dim FG
                                     4:TxtStyle:=TxtStyle+[fsUnderline];   // underline
                                     5:begin end;                          // (not supported)
                                     7:InvText:=true;                      // reverse video
                                30..37:FGcolour:=J-30;
                                40..47:BGcolour:=J-40
                           end  { of case }
                         end;
                         pass
                       end
                     end;
                 'r':begin
                       n:=PC(S);
//                     ShowMessage('set scroll window |'+S+'|'+VTline+'| '+IntToStr(n));
                       case n of 0:begin
                                     TM:=-maxint;
                                     BM:=+maxint;
//                                   ShowMessage('zero parameters');
                                     pass
                                   end;
                                 2:begin
                                     I:=Pn(S,1);
                                     J:=Pn(S,2);
                                     if (I<J) and (I>=1)    then TM:=I
                                                            else TM:=-maxint;
                                     if (I<J) and (J<=ROWS) then BM:=J
                                                            else BM:=+maxint;
//                                   ShowMessage('top margin = '+IntToStr(I)+
//                                          '  bottom margin = '+IntToStr(J));
                                     pass
                                   end
                              else fail
                       end  { of case }
                     end
              else   fail
      end  { of case }
    end
    else

    if pos(#27, VTline)=1 then               // process a complete <esc> string
    begin
      if length(VTline)=1 then exit;         // still building command string
      if ch='[' then exit;                   // still building command string

//    S:=copy(VTline, 2, length(VTline)-2);  // extract parameter segment

      case ch of '7':begin                   // save cursor position and attributes
                       Xsave:=Xpos;
                       Ysave:=Ypos;
                       pass
                     end;
                 '8':begin                   // restore cursor position and attributes
                       if (Xsave>0) and (Ysave>0) then gotoxy(Xsave,Ysave);
                       pass
                     end;
                 'E':begin                   // same as ^[D (below) plus a CR
//                     ShowMessage('esc-E');
                       if Ypos<Min(COLS,BM) then inc(Ypos) else
                       begin
                         scroll(1, Max(1,TM), COLS, Min(ROWS,BM), +1);
                       end;
                       Xpos:=1;
                       pass
                     end;
                 'D':begin                   // scroll up if cursor is at bottom of window
//                     ShowMessage('esc-D');
                       if Ypos<Min(COLS,BM) then inc(Ypos) else
                       begin
                         scroll(1, Max(1,TM), COLS, Min(ROWS,BM), +1);
                       end;
                       pass
                     end;
                 'M':begin                   // scroll down if cursor is at top of window
//                     ShowMessage('esc-M');
                       if Ypos>Max(1,TM) then dec(Ypos) else
                       begin
                         scroll(1, Max(1,TM), COLS, Min(ROWS,BM), -1);
                       end;
                       pass
                     end
              else   fail
      end;  { of case }
    end else fail
  end
end;


////////////////////////////////////////////////////////////////////////////////
// the following is a GFX command processing engine. it takes characters one
// at a time via the parameter 'ch'. normally these are simply passed out
// unaltered as a one character long return string to then be passed onto
// emit(ch).
//
// however, when a GFX command sequence is detected characters are accumulated
// in the internal string 'GFXline'. once matched to a valid GFX command, the
// command is enacted. while if the string accumulated is detected as invalid,
// the whole string is returned.
////////////////////////////////////////////////////////////////////////////////

function GFXengine(ch:char):string;
const GFXflag:boolean=false;        // internally held flag
      GFXline:string='';            // internally held string
      GFXpass:boolean=false;        // true if we've just succeeded in decoding
var params:array[1..16] of integer;
    CMD, S, PSn:string;
        I, J, n:integer;

  procedure fail;             // failed to decode string
  begin
    if Form2.Visible then with Form2.RichEdit1 do
    begin
      inc(CLC);
      Lines.BeginUpdate;
      if CLC>999 then Lines.Delete(0);
      Lines.Add(Format('%.6d  ',[CLC mod 1000000])+
                'FAIL: <DLE>'+copy(GFXline,2,length(GFXline)-2));
      SendMessage(Handle, WM_VSCROLL, SB_BOTTOM, 0);
      Lines.EndUpdate
    end;

    GFXengine:=GFXline;       // return complete string
    GFXline:='';
    GFXflag:=false            // drop out of GFX mode
  end;

  procedure pass;             // sucessfully processed string
  begin
    if Form2.Visible then with Form2.RichEdit1 do
    begin
      inc(CLC);
      Lines.BeginUpdate;
      if CLC>999 then Lines.Delete(0);
      Lines.Add(Format('%.6d  ',[CLC mod 1000000])+
                'PASS: <DLE>'+copy(GFXline,2,length(GFXline)-2));
      SendMessage(Handle, WM_VSCROLL, SB_BOTTOM, 0);
      Lines.EndUpdate
    end;

    GFXline:='';
    GFXflag:=false;           // drop out of GFX mode
    GFXpass:=true
  end;

begin
  if GFXpass and (ch=#10) then       // supress trailing LF for BASIC compatibility
  begin
    GFXpass:=false;
    GFXengine:='';
    exit
  end;

  if ch=#16 then GFXflag:=true;
  if not GFXflag then GFXengine:=ch else
  begin
    GFXengine:='';
    GFXline:=GFXline+ch;

    if (GFXline[1]=#16) and (GFXline[length(GFXline)]=#13) then
    begin                          // process a complete <dle> string
//  format is:  <DLE> Command [,|<TAB>|<SPC>]  Param1 [,|<TAB><SPC>]  Param2... <cr><lf>

      S:=GFXline;

// the below FOR and WHILE loops perform the following:
// - convert every control character, space, comma and semicolon into a TAB
// - convert all consecutive groups of TABs into a single TAB
// - remove any leading TABs from the beginning
// - remove any trailing TABs from the end
      for I:=1 to length(S) do if S[I] in [#00..#32,',',';'] then S[I]:=#09;

      I:=pos(#09#09,S);
      while I<>0 do                // convert pairs of TABs into single TABs
      begin
        delete(S, I, 1);
        I:=pos(#09#09,S)
      end;

      while (length(S)<>0) and (S[1]=#09) do
          delete(S, 1, 1);                     // remove leading TABs
      while (length(S)<>0) and (S[length(S)]=#09) do
          delete(S, length(S), 1);             // remove trailing TABs

      if length(S)=0 then fail;
      if not GFXflag then exit;

// next the command is peeled off the start of the string, and converted to upper case
(*
      I:=1;
      while (I<=length(S)) and (S[I] in ['a'..'z', 'A'..'Z','?']) do inc(I);  // first non-letter
      if I>length(S) then I:=0                                                // none found
                     else if S[I]<>#9 then insert(#9,S,I);   // hack to put tab after command
*)
      I:=pos(#09, S);                // old version, fails with negative # following command

      if I<>0 then begin
                     CMD:=UpperCase(copy(S, 1, I-1));
                     delete(S, 1, I)
                   end
              else begin
                     CMD:=S;
                     S:=''
                   end;

// now we (1) abbreviate/shorten the command to a single letter, and,
//        (2) decide how many parameters we are expecting to see
      if length(CMD)<>1 then
      if CMD='CLEAR'  then CMD:='C' else
      if CMD='INK'    then CMD:='I' else
      if CMD='LINE'   then CMD:='L' else
      if CMD='PLOT'   then CMD:='P' else
      if CMD='ARC'    then CMD:='A' else
      if CMD='FILL'   then CMD:='F' else
      if CMD='MOVETO' then CMD:='M' else
      if CMD='DRAWTO' then CMD:='D' else
      if CMD='SCROLL' then CMD:='S'
                      else fail;               // failed to identify a long command
      if not GFXflag then exit;

      n:=0;                                    // suppress compiler warning
      case CMD[1] of 'P', 'F', 'M', 'D':n:=2;
                          'C', 'I', 'L':n:=4;
                               'A', 'S':n:=6;
                                    '?':n:=0
                  else                  fail   // failed to identify a short command
      end;  { of case }
      if not GFXflag then exit;

// the next thing to do is to separate out the parameters
      for I:=1 to n do
      begin
        J:=pos(#09, S);
        if J<>0 then begin
                       PSn:=copy(S, 1, J-1);
                       delete(S, 1, J)
                     end
                else begin
                       PSn:=S;
                       S:=''
                     end;

        try
          params[I]:=trunc(StrToFloat(PSn))
        except
          fail;
          exit
        end
      end;

      case CMD[1] of 'C':GFXclear(params[1], params[2], params[3], params[4]);
                     'I':GFXink(params[1], params[2], params[3], params[4]);
                     'L':GFXlineAB(params[1], params[2], params[3], params[4]);
                     'P':GFXplot(params[1], params[2]);
                     'A':GFXarc(params[1], params[2], params[3], params[4], params[5], params[6]);
                     'F':GFXfill(params[1], params[2]);
                     'M':GFXmoveto(params[1], params[2]);
                     'D':GFXdrawto(params[1], params[2]);
                     'S':GFXscroll(params[1], params[2], params[3], params[4], params[5], params[6]);
                     '?':WriteComm(IntToStr(Gw)+', '+IntToStr(Gh)+#13)
                  else   fail
      end;  { of case }
      if GFXflag then pass
    end  { end of processing a valid GFX command string }
  end
end;


////////////////////////////////////////////////////////////////////////////////
// Timer event handlers (x3)
// Timer1: 500mS, flash cursor
// Timer2: 20mS, update status bar and cursor location
// Timer3: 20mS, process incoming and outgoing serial data
////////////////////////////////////////////////////////////////////////////////

procedure TForm1.Timer1Timer(Sender: TObject);     // flash cursor
const flag:boolean=false;
begin
  flag:=not flag;
  CSR.Visible:=flag or (CSR.Tag=1);                // cursor always visible if it has moved
  CSR.Tag:=0;

  if flag then Label7.Color:=clRed
          else Label7.Color:=clLime
end;


procedure TForm1.Timer2Timer(Sender: TObject);     // update status bar and cursor location
var I:int64;
    S:string;
begin
  Label1.Caption:=Format('%.3d', [ord(lastC)]);
  Label2.Caption:=Format('row=%.2d', [Ypos]);
  Label3.Caption:=Format('col=%.2d', [Xpos]);
  Label4.Caption:=Format('key=%.3d', [ord(lastK)]);

  I:=timesince(TC1);
  S:=Format('%.10d', [I]);
  if I<1000  then Label5.Caption:=copy(S,8,3)+'ms' else
  if I<60999 then Label5.Caption:=copy(S,6,2)+'.'+S[8]+'s' else
                  Label5.Caption:='>1min';
  Label5.Visible:=CONNECTED;                  // hide Rx timer if no connection

  I:=timesince(TC2);
  S:=Format('%.10d', [I]);
  if I<1000  then Label6.Caption:=copy(S,8,3)+'ms' else
  if I<60999 then Label6.Caption:=copy(S,6,2)+'.'+S[8]+'s' else
                  Label6.Caption:='>1min';

  Label7.Visible:=CONNECTED;                  // hide 'CONNECTED' indicator
  Label8.Visible:=LOGTOFILE;

  Label9.Caption:=Format('[%.6d]', [min(999999, max(CBlength-CBindex, 0))]);
  Label9.Visible:=(CBindex<>0);

  Label10.Caption:='('+IntToStr(mouseX)+','+IntToStr(mouseY)+')';

  if (Xpos>=1) and (Xpos<=COLS) and (Ypos>=1) and (Ypos<=ROWS) then
  begin
    CSR.Top:=Image1.Top+(CSR.Height*(Ypos-1));
    CSR.Left:=Image1.Left+(CSR.Width*(Xpos-1))
//  if CSR.Tag=1 then begin CSR.Visible:=true; CSR.Tag:=0 end
  end;
/////////////////////////////////////////////////////
//  GFXink(random(256), random(256), random(256), 1);
//  GFXplot(random(Gw), random(Gh))
/////////////////////////////////////////////////////
end;


procedure TForm1.Timer3Timer(Sender: TObject);     // serial ticker
var ch:char;
   I1,I2:integer;
   S1,S2:string;
begin
  while CONNECTED and ReadComm(ch) do                  // text and VT100 escape sequences
  begin
    TC1:=GetTickCount;

////////////////////////////////////////////////////////////////////////////////

    S1:=VT100engine(ch);                       // first process throught the VT100 engine
    for I1:=1 to length(S1) do
    begin
      S2:=GFXengine(S1[I1]);                   // then process through the GFX engine
      for I2:=1 to length(S2) do emit(S2[I2])  // lastly print out the remaining characters
    end

////////////////////////////////////////////////////////////////////////////////

  end;

  if (timesince(TC1)>60) and (CBindex<>0) and (CBlength<>0) then
  begin
    repeat
      ch:=CBstring[CBindex];
      WriteBuffer:=WriteBuffer+ch;
      inc(CBindex);
    until (CBindex>CBlength) or (ch=#13);

    if (CBindex>CBlength) then
    begin
      CBindex:=0;
      CBlength:=0;
      CBstring:=''
    end
  end;

  if CONNECTED and (length(WriteBuffer)<>0) then      // keyboard input
  begin
    WriteComm(WriteBuffer);
    WriteBuffer:=''
  end;

  if BreakCounter<>-1 then                   // BreakCounter is active
  begin
    if BreakCounter=0 then try SetCommBreak(CommFile) except end;
    Inc(BreakCounter, Timer3.Interval);

    if BreakCounter>100 then                 // after 100mS return to idle state
    try
      BreakCounter:=-1;
      ClearCommBreak(CommFile)
    except
    end
  end

end;


////////////////////////////////////////////////////////////////////////////////
// Keyboard and Mouse Events
// =========================
////////////////////////////////////////////////////////////////////////////////

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
const A1:integer=150;
      A2:integer=150;
begin
  if Memo1.Visible then exit;                  // ignore keys if text buffer visible
  if Panel1.Visible then exit;                 // ignore keys if button panel visible

  lastK:=Key;
  if CBindex=0 then if CONNECTED then WriteBuffer:=WriteBuffer+Key
                                 else emit(Key);
(*
  GFXink(0, 0, 1, 6);
  GFXarc(100, 100, 200, 200, A1, A2);

  case Key of 'a':A1:=A1-5;
              's':A1:=A1+5;
              'k':A2:=A2-5;
              'l':A2:=A2+5
  end;  { of case}
  while A1<0    do A1:=A1+360;
  while A1>=360 do A1:=A1-360;
  while A2<0    do A2:=A2+360;
  while A2>=360 do A2:=A2-360;
  Label9.Caption:=Format('%.3d to %.3d', [A1, A2]);

  GFXink(255, 255, 255, 2);
  GFXarc(100, 100, 200, 200, A1, A2);
*)
(*
  case Key of 'w':begin A2:=A2-1; GFXscroll(A1-70, A2-70, A1+70, A2+70, 0, -1) end;
              'z':begin A2:=A2+1; GFXscroll(A1-70, A2-70, A1+70, A2+70, 0, +1) end;
              'a':begin A1:=A1-1; GFXscroll(A1-70, A2-70, A1+70, A2+70, -1, 0) end;
              's':begin A1:=A1+1; GFXscroll(A1-70, A2-70, A1+70, A2+70, +1, 0) end
  end;  { of case }
*)
  TC2:=GetTickCount
end;


procedure TForm1.WMKeyDown(var Msg:TWMKeyDown);
var S:string;
begin
  if Memo1.Visible then exit;                  // ignore keys if text buffer visible
  if Panel1.Visible then exit;                 // ignore keys if button panel visible

  S:='';
  case Msg.CharCode of VK_LEFT:S:=#27+'[D';
                         VK_UP:S:=#27+'[A';
                      VK_RIGHT:S:=#27+'[C';
                       VK_DOWN:S:=#27+'[B';
                      VK_PRIOR:S:=#27+'[5~';
                       VK_NEXT:S:=#27+'[6~';
                       VK_HOME:S:=#27+'[1~';
                        VK_END:S:=#27+'[4~';
                     VK_INSERT:S:=#27+'[2~'
  end;  { of case }

//ShowMessage(IntToStr(message.CharCode));

  if CONNECTED and (CBindex=0) then WriteBuffer:=WriteBuffer+S;
  TC2:=GetTickCount
end;


procedure TForm1.FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
var S:string;
begin
  if Memo1.Visible then                        // ignore keys if text buffer visible
  begin
    if (Key=13) or (Key=27) then               // except hide Memo1 on ESC or CR
    begin
      Memo1.Lines.Clear;
      Memo1.Enabled:=false;                    // probably not needed
      Memo1.Visible:=false;
      Memo1.SendToBack;                        // probably not needed
      Form1.SetFocus                           // probably not needed
    end;
    exit
  end;

  if Panel1.Visible then                       // ignore keys if button panel visible
  begin
    if (Key=13) or (Key=27) then               // except hide Panel1 on ESC or CR
    begin
      Panel1.Visible:=false;
      Form1.SetFocus                           // probably not needed

    end;
    exit
  end;

// ssShift	The Shift key is held down.
// ssAlt	The Alt key is held down.
// ssCtrl	The Ctrl key is held down.

  S:='';

// *** shifted and unshifted function keys ***
  if ssShift in Shift
  then case Key of VK_F3:S:=#27+'[25~';        // shifted function keys
                   VK_F4:S:=#27+'[26~';
                   VK_F5:S:=#27+'[28~';
                   VK_F6:S:=#27+'[29~';
                   VK_F7:S:=#27+'[31~';
                   VK_F8:S:=#27+'[32~';
                   VK_F9:S:=#27+'[33~';
                  VK_F10:S:=#27+'[34~'
                else     S:=''
       end  { of case }
  else case Key of VK_F1:S:=#27+'[11~';        // unshifted function keys
                   VK_F2:S:=#27+'[12~';
                   VK_F3:S:=#27+'[13~';
                   VK_F4:S:=#27+'[14~';
                   VK_F5:S:=#27+'[15~';
                   VK_F6:S:=#27+'[17~';
                   VK_F7:S:=#27+'[18~';
                   VK_F8:S:=#27+'[19~';
                   VK_F9:S:=#27+'[20~';
                  VK_F10:S:=#27+'[21~';
                  VK_F11:S:=#27+'[23~';
                  VK_F12:S:=#27+'[24~'
       end;

// *** alt keys (letters and numbers) ***
  if ssAlt in Shift then
  begin
    case Key of ord('B'):if CONNECTED then BreakCounter:=0;    // reset micromite
                ord('C'):GFXclear(0, 0, Gw, Gh);               // clear graphics layer
                ord('Z'):begin                                 // cancel paste
                           CBindex:=0;
                           CBlength:=0;
                           CBstring:=''
                         end;
                ord('0'):Form2.RichEdit1.Lines.Add('++++++++++++++++++++++++');
                ord('1'):CSR.Font.Size:=9;     // 9pt
                ord('2'):CSR.Font.Size:=12;    // 12pt
                ord('3'):CSR.Font.Size:=14;    // 14pt
    end;  { of case }

// **** adjust dimensions of everything on screen to match new point size ***
    if Key in [ord('1'), ord('2'), ord('3')] then
    begin
      Image1.Width:=CSR.Width*COLS;            // set width
      Image1.Height:=CSR.Height*ROWS;          // set height

      Image2.Width:=Image1.Width;
      Image2.Height:=Image1.Height;

      Memo1.Width:=Image1.Width;
      Memo1.Height:=Image1.Height;
      Memo1.Font:=CSR.Font;
      Memo1.Font.Color:=clBlack;
      Memo1.Font.Style:=[];
      FillChar(TextStore, sizeof(TextStore), ' ');

      Panel1.Left:=(Image1.Width div 2) - (Panel1.Width div 2);
      Panel1.Top:=Image1.Top+30;

      Image1.Picture.Graphic.Width:=Image1.Width;      // set width
      Image1.Picture.Graphic.Height:=Image1.Height;    // set height

      Image2.Picture.Graphic.Width:=Image2.Width;      // set width
      Image2.Picture.Graphic.Height:=Image2.Height;    // set height

      SCR.Font:=Cursor.Font;                 // copy font details from cursor object

      clear(1, 1, COLS, ROWS);                 // clear text layer
      GFXclear(0, 0, Gw, Gh);                  // clear graphics layer
      gotoxy(1,1)                              // home cursor
    end
  end;

  if Key=VK_Delete then S:=#127;               // convert delete key to chr(127)

  if Key=VK_F10 then Key:=0;                   // stop f10 triggering menu

  if CONNECTED and (CBindex=0) then WriteBuffer:=WriteBuffer+S;
  TC2:=GetTickCount
end;


procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if CONNECTED then SpeedButton1.Caption:='DISCONNECT'
               else SpeedButton1.Caption:='CONNECT';
  if LOGTOFILE then SpeedButton2.Caption:='STOP'#13'logging'
               else SpeedButton2.Caption:='LOG'#13'to file';
  SpeedButton3.Caption:='show as text'#13'window';
  SpeedButton4.Caption:='paste from'#13'clipboard';
  SpeedButton5.Caption:='load from'#13'text file';
  if Form2.Visible then SpeedButton6.Caption:='hide command'#13'window'
                   else SpeedButton6.Caption:='show command'#13'window';

  if Button=mbRight then Panel1.Visible:=true
end;


procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var Xofs, Yofs:integer;
begin
  if Sender=Form1 then begin Xofs:=0; Yofs:=0 end else
  if Sender=Label1 then begin Xofs:=Label1.left; Yofs:=Label1.Top end else
  if Sender=Label2 then begin Xofs:=Label2.left; Yofs:=Label2.Top end else
  if Sender=Label3 then begin Xofs:=Label3.left; Yofs:=Label3.Top end else
  if Sender=Label4 then begin Xofs:=Label4.left; Yofs:=Label4.Top end else
  if Sender=Label5 then begin Xofs:=Label5.left; Yofs:=Label5.Top end else
  if Sender=Label6 then begin Xofs:=Label6.left; Yofs:=Label6.Top end else
  if Sender=Label7 then begin Xofs:=Label7.left; Yofs:=Label7.Top end else
  if Sender=Label8 then begin Xofs:=Label8.left; Yofs:=Label8.Top end else
  if Sender=Label9 then begin Xofs:=Label9.left; Yofs:=Label9.Top end else
  if Sender=Label10 then begin Xofs:=Label10.left; Yofs:=Label10.Top end else

  if Sender=Memo1 then begin Xofs:=Memo1.left; Yofs:=Memo1.Top end else
  if Sender=Panel1 then begin Xofs:=Panel1.left; Yofs:=Panel1.Top end else

  if Sender=SpeedButton1 then begin Xofs:=Panel1.left+SpeedButton1.Left; Yofs:=Panel1.Top+SpeedButton2.Top end else
  if Sender=SpeedButton2 then begin Xofs:=Panel1.left+SpeedButton2.Left; Yofs:=Panel1.Top+SpeedButton2.Top end else
  if Sender=SpeedButton3 then begin Xofs:=Panel1.left+SpeedButton3.Left; Yofs:=Panel1.Top+SpeedButton3.Top end else
  if Sender=SpeedButton4 then begin Xofs:=Panel1.left+SpeedButton4.Left; Yofs:=Panel1.Top+SpeedButton4.Top end else
  if Sender=SpeedButton5 then begin Xofs:=Panel1.left+SpeedButton5.Left; Yofs:=Panel1.Top+SpeedButton5.Top end else
  if Sender=SpeedButton6 then begin Xofs:=Panel1.left+SpeedButton6.Left; Yofs:=Panel1.Top+SpeedButton6.Top end
                         else begin Xofs:=0; Yofs:=0 end;

  mouseX:=X+Xofs;
  mouseY:=Y+Yofs
//Label10.Caption:='('+IntToStr(X+Xofs)+','+IntToStr(Y+Yofs)+')'
end;


////////////////////////////////////////////////////////////////////////////////
// startup (FormCreate) and shutdown (FormClose) code
// ==================================================
////////////////////////////////////////////////////////////////////////////////

procedure TForm1.FormCreate(Sender: TObject);
begin
  Form1.Caption:='Graphical Console Demo  (build: 20-August-2017)';
  Form1.AutoSize:=true;
  Form1.AutoScroll:=false;
  Form1.KeyPreview:=true;
  Form1.DoubleBuffered:=true;

  CSR:=Cursor;         // CSR is shorthand for the cursor object

  Image1.Left:=0;                      // horizontal position of screen grid
  Image1.Top:=Label1.Height+2;         // vertical position of screen grid
  Image1.Width:=CSR.Width*COLS;        // set width
  Image1.Height:=CSR.Height*ROWS;      // set height

  Image2.Left:=Image1.Left;            // graphics plane overlays text plane
  Image2.Top:=Image1.Top;
  Image2.Width:=Image1.Width;
  Image2.Height:=Image1.Height;

  Memo1.Left:=Image1.Left;             // text copy object
  Memo1.Top:=Image1.Top;
  Memo1.Width:=Image1.Width;
  Memo1.Height:=Image1.Height;
  Memo1.Font:=CSR.Font;
  Memo1.Font.Color:=clBlack;
  Memo1.Font.Style:=[];
  Memo1.Color:=clWhite;
  FillChar(TextStore, sizeof(TextStore), ' ');

  Panel1.Left:=(Image1.Width div 2) - (Panel1.Width div 2);
  Panel1.Top:=Image1.Top+30;
  Panel1.Visible:=false;               // hide button panel by default
(*
  SpeedButton1.Caption:='CONNECT';
  SpeedButton2.Caption:='LOG'#13'to file';
  SpeedButton3.Caption:='show as text'#13'window';
  SpeedButton4.Caption:='paste from'#13'clipboard';
  SpeedButton5.Caption:='load from'#13'text file';
  SpeedButton6.Caption:='show command'#13'window';
*)
  Label7.Color:=clGreen;               // green 'running' annunciator by default
  Label8.Color:=$000080FF;             // orange 'logging' annunciator by default

  OpenDialog1.InitialDir:=ExtractFilePath(ExpandFileName(paramstr(0)));
  SaveDialog1.InitialDir:=ExtractFilePath(ExpandFileName(paramstr(0)));

// create text area
  Image1.Picture.Graphic:=TBitmap.create;          // create a bitmap object for text
  Image1.Picture.Graphic.Width:=Image1.Width;      // set width
  Image1.Picture.Graphic.Height:=Image1.Height;    // set height

// create graphics area
  Image2.Transparent := TRUE;                          // allow transparence
  Image2.Picture.Graphic:=TBitmap.create;              // create a bitmap object for graphics
  Image2.Picture.Graphic.Width:=Image2.Width;          // set width
  Image2.Picture.Graphic.Height:=Image2.Height;        // set height
  Image2.Picture.Bitmap.TransparentColor := clBlack;   // transparent colour is black
  Image2.Picture.Bitmap.TransparentMode := tmFixed;    // use above setting for TC

// align graphics and text layers
  Memo1.Enabled:=false;
  Memo1.Visible:=false;
  Memo1.SendToBack;
  Image1.Enabled:=false;                     // ignore mouse and keyboard events
  Image2.Enabled:=false;                     // ignore mouse and keyboard events
  Image1.BringToFront;                       // text layer ends in background
  Image2.BringToFront;                       // graphics layer overlays text
  Cursor.BringToFront;                       // cursor always on top of text and graphics
  Panel1.BringToFront;                       // buttons panel on top of everything else

  CSR.Top:=Image1.Top;                   // initial cursor row
  CSR.Left:=Image1.Left;                 // initial cursor column
  CSR.Font.Color:=clRed;                 // initial cursor colour (FG)
  CSR.Color:=clRed;                      // initisl cursor colour (BG)

  SCR:=Image1.Picture.Bitmap.Canvas;     // shorthand for canvas object (text screen)
  SCR.Font:=Cursor.Font;                 // copy font details from cursor object
  SCR.TextFlags:=ETO_OPAQUE;             // opaque writing of text, improves speed
///////////////////////////////////////////////////////////////////////////////////////////////
  SCR.Font.Style:=[];                    // no underline, etc.       ##########################
///////////////////////////////////////////////////////////////////////////////////////////////
  SCR.Brush.Color:=clBlack;              // default brush: clBlack (for clearing screen)
  SCR.Pen.Color:=clWhite;                // default pen: clWhite (for writing text)

  GFX:=Image2.Picture.Bitmap.Canvas;     // shorthand for canvas object (graphics screen)
  GFX.Brush.Color:=clBlack;              // default brush: clBlack (for clearing screen)
  GFX.Pen.Color:=clRed;                  // default pen: clRed (for drawing lines)

  clear(1, 1, COLS, ROWS);               // clear text layer
  GFXclear(0, 0, Gw, Gh);                // clear graphics layer

  TC1:=GetTickCount;
  TC2:=GetTickCount

//  test code:
(*
  GFXlineAB(0, 0, Gw-1, Gh-1);
  GFXlineAB(150,  50, 150, 250);
  GFXlineAB( 50, 150, 250, 150)

  GFXink(255, 255, 0, 6);
  GFXarc(100, 100, 200, 200, 0, 0);
*)
end;


procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if CONNECTED then try CloseHandle(CommFile) except end;
  if LOGTOFILE then try CloseFile(Logfile) except end;

  sleep(200)
end;


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
procedure CaptureConsoleOutput(const ACommand, AParameters: String;
                               var ExitCode: integer);
var saSecurity:TSecurityAttributes;
    suiStartup:TStartupInfo;
     piProcess:TProcessInformation;
    ReadBuffer:array[0..127] of Char;
     BytesRead,
    BytesAvail:DWord;
       Running:DWord;
           I,J:integer;
             S:string;
            ch:char;
            LB:LongBool;
 begin
   ExitCode:=-($DEAD);         // default exit code if unable to complete

   FillChar(saSecurity, SizeOf(TSecurityAttributes), #0);
   saSecurity.nLength:=SizeOf(TSecurityAttributes);
   saSecurity.bInheritHandle:=true;            // seems to be essential for pipes
   saSecurity.lpSecurityDescriptor:=nil;

   if CreatePipe(hRead_local, hWrite_remote, @saSecurity, 0) then
   if CreatePipe(hRead_remote, hWrite_local, @saSecurity, 0) then     { try 1 byte write }
   begin
     FillChar(suiStartup, SizeOf(TStartupInfo), #0);
     suiStartup.cb:=SizeOf(TStartupInfo);
     suiStartup.hStdInput:=hRead_remote;
     suiStartup.hStdOutput:=hWrite_remote;
     suiStartup.hStdError:=hWrite_remote;
     suiStartup.dwFlags:=STARTF_USESTDHANDLES or STARTF_USESHOWWINDOW;
     suiStartup.wShowWindow:=SW_HIDE;
{
   dwXCountChars, dwYCountChars
dwFlags specifies STARTF_USECOUNTCHARS.
For console processes,
if a new console window is created,
dwXCountChars specifies the screen buffer
width in character columns, and dwYCountChars
specifies the screen buffer height in character rows.
These values are ignored in GUI processes.  }

     saSecurity.bInheritHandle:=false;         // standard handles are still inherited

     if CreateProcess(nil, PChar(ACommand + ' ' + AParameters),
                      @saSecurity, @saSecurity,
//                    nil, nil,
                      True, NORMAL_PRIORITY_CLASS,
                      nil, nil, suiStartup, piProcess) then
     begin
       CONNECTED:=true;
// ***************************************
//     try CloseHandle(hWrite) except ShowMessage('unable to close hWrite') end;
// ***************************************

       repeat
         Running:=WaitForSingleObject(piProcess.hProcess, 20);
//       Application.ProcessMessages();
//       inc(LC1);
         repeat
//         inc(LC2);
           Application.ProcessMessages();
           try
             if PeekNamedPipe(hRead_local, nil, 0, nil, @BytesAvail, nil) and (BytesAvail>0)
                then LB:=ReadFile(hRead_local, ReadBuffer[0],
                                  Min(sizeof(ReadBuffer), BytesAvail), BytesRead, nil)
                else LB:=false
           except
             LB:=false
           end;       // may exit with ERROR_BROKEN_PIPE after child process closes

           if not LB then BytesRead:=0 else
           begin
             for I:=1 to BytesRead do
             begin
               ch:=ReadBuffer[I-1];
               S:=VT100engine(ch);
               for J:=1 to length(S) do emit(S[J])
             end
           end;
         until (BytesRead<sizeof(ReadBuffer)) or KILL
       until (Running<>WAIT_TIMEOUT) or KILL;

       CONNECTED:=false;

       GetExitCodeProcess(piProcess.hProcess, DWORD(ExitCode));  // returns STILL_ACTIVE if still running
       if KILL then TerminateProcess(piProcess.hProcess, 0);

       try CloseHandle(piProcess.hProcess) except end;
       try CloseHandle(piProcess.hThread) except end
     end;

     try CloseHandle(hRead_local) except end;
     try CloseHandle(hWrite_local) except end;
     try CloseHandle(hRead_remote) except end;
     try CloseHandle(hWrite_remote) except end

   end;
   DEAD:=true
end;


(*
procedure RUNprogram;
var I:integer;
    S:string;
begin
  if not CONNECTED then
  if inputquery('RUN', 'enter program to launch', S) then
  begin
    DEAD:=false;
    KILL:=false;
    emit(#13);
    emit(#10);
    CaptureConsoleOutput(S,'', I);
    emit(#13);
    emit(#10)
  end
end;


procedure STOPprogram;
begin
  KILL:=true
end;
*)
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// Button (on Panel1) handlers
// ===========================
////////////////////////////////////////////////////////////////////////////////

// ########################################## connect/disconnect button ########
procedure TForm1.SpeedButton1Click(Sender: TObject);
const S:string='';
var name,config:string;
             ok:boolean;
              I:integer;
begin
  if not CONNECTED then repeat
                          ok:= inputquery('CONNECT', 'enter <port>:<baud>', S);
                          if ok then
                          begin
                            I:=pos(':',S);

                            if I<>0 then
                            begin
                              name:=copy(S,1,I-1);
                              config:='baud='+copy(S,I+1,length(S)-I)+' parity=n data=8 stop=1';
                              SetupCommPort(name, config)
                            end
                          end
                        until CONNECTED or not ok
                   else begin
                          try CloseHandle(CommFile) except end;
                          CONNECTED:=false
                        end;

  if CONNECTED then SpeedButton1.Caption:='DISCONNECT'
               else SpeedButton1.Caption:='CONNECT';
  Panel1.Visible:=false
end;


// ################################## start/stop logging to file button ########
procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  if not LOGTOFILE then begin
                          if SaveDialog1.Execute then
                          try
                            AssignFile(LogFile, SaveDialog1.Filename);
                            ReWrite(LogFile);
                            LOGTOFILE:=true
                          except
                            try CloseFile(Logfile) except end;
                            LOGTOFILE:=false
                          end
                        end
                   else begin
//                        try CloseHandle(CommFile) except end;
                          try CloseFile(LogFile) except end;
                          LOGTOFILE:=false
                        end;

//LOGTOFILE:=not LOGTOFILE;
  if LOGTOFILE then SpeedButton2.Caption:='STOP'#13'logging'
               else  SpeedButton2.Caption:='LOG'#13'to file';
  Panel1.Visible:=false
end;


// ######################################## select and copy text button ########
procedure TForm1.SpeedButton3Click(Sender: TObject);
var X, Y:integer;
       S:string;
begin
  Memo1.Lines.Clear;
  for Y:=1 to ROWS do                          // fill in memo text
  begin
    S:=StringOfChar(' ', COLS);
    for X:=1 to 80 do S[X]:=TextStore[X,Y];
    Memo1.Lines.Add(S)
  end;

  Panel1.Visible:=false;

  Memo1.Enabled:=true;                         // probably not needed
  Memo1.Visible:=true;
  Memo1.BringToFront;                          // probably not needed
  Memo1.SetFocus                               // probably not needed
end;


// ################################### paste text from clipboard button ########
procedure TForm1.SpeedButton4Click(Sender: TObject);
var S:string;
    I:integer;
begin
  if CBindex<>0 then exit;             // exit if paste operation already in progress
  if ClipBoard.HasFormat(CF_TEXT) and (CBindex=0) then
  try
    S:=ClipBoard.AsText;
    I:=pos(#13#10, S);

    while I<>0 do
    begin                              // translate all CR-LF pairs into single CR
      delete(S, I, 2);
      insert(#13, S, I);
      I:=pos(#13#10, S)
    end;

    for I:=1 to length(S) do           // translate any remaining LFs into CRs
        if S[I]=#10 then S[I]:=#13;
    for I:=length(S) downto 1 do       // remove any other control characters
        if S[I] in [#0..#12,#14..#31] then delete(S, I, 1);

    if length(S)<>0 then
    begin
      CBstring:=S;                     // place into string to be streamed out
      CBlength:=length(S);             // the comm port by a timer interrupt
      CBindex:=1;
      S:=''                            // S could be pretty big, so best to empty it
    end
  except
  end;

  Panel1.Visible:=false
end;


// ######################################## paste text from file button ########
procedure TForm1.SpeedButton5Click(Sender: TObject);
var SL:TStringList;
     S:string;
     I:integer;
begin
  if CBindex<>0 then exit;             // exit if paste operation already in progress
  SL:=nil;

  if OpenDialog1.Execute then
  try
//  ShowMessage(OpenDialog1.FileName);
    SL:=TStringlist.Create;
    SL.LoadFromFile(OpenDialog1.Filename);
//  ShowMessage(SL.Text);
    S:=SL.Text;
    I:=pos(#13#10, S);

    while I<>0 do
    begin                              // translate all CR-LF pairs into single CR
      delete(S, I, 2);
      insert(#13, S, I);
      I:=pos(#13#10, S)
    end;

    for I:=1 to length(S) do           // translate any remaining LFs into CRs
        if S[I]=#10 then S[I]:=#13;
    for I:=length(S) downto 1 do       // remove any other control characters
        if S[I] in [#0..#12,#14..#31] then delete(S, I, 1);

    if length(S)<>0 then
    begin
      CBstring:=S;                     // place into string to be streamed out
      CBlength:=length(S);             // the comm port by a timer interrupt
      CBindex:=1;
      S:=''                            // S could be pretty big, so best to empty it
    end
  except
  end;

  if SL<>nil then try SL.Free except end;
  Panel1.Visible:=false
end;


// ################################################ show/hide error log ########
procedure TForm1.SpeedButton6Click(Sender: TObject);
begin
  Form2.DoubleBuffered:=true;
  Form2.Visible:=not Form2.Visible;
  if Form2.Visible then SpeedButton6.Caption:='hide command'#13'window'
                   else SpeedButton6.Caption:='show command'#13'window';
  Panel1.Visible:=false
end;




end.
